#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <vector>
#include <math.h>
#include <algorithm>

using namespace std;

const int N=1e5+10;

int a[N];
int seg[2*N];
int br[2*N];

int n,q;

void init(int i, int leva, int desna)
{
    if (leva==desna)
    {
        seg[i]=a[leva];
        br[i]=1;
        return;
    }
    int mid=(leva+desna)/2;
    init(2*i,leva,mid);
    init(2*i+1,mid+1,desna);
    br[i]=br[2*i]+br[2*i+1];
    if (br[i]>1) seg[i]=seg[2*i]&seg[2*i+1];
    else seg[i]=seg[2*i]+seg[2*i+1];
}

void update(int i, int leva, int desna, int x, int val)
{
    if (leva==desna)
    {
        seg[i]=a[leva];
        br[i]=1;
        //printf("i:%d leva:%d desna:%d  seg:%d, br:%d\n",i,leva,desna, seg[i], br[i]);
        return;
    }
    int mid=(leva+desna)/2;
    if (x<=mid) update(2*i,leva,mid,x,val);
    else update(2*i+1,mid+1,desna,x,val);
    br[i]=br[2*i]+br[2*i+1];
    if (br[i]>1) seg[i]=seg[2*i]&seg[2*i+1];
    else seg[i]=seg[2*i]+seg[2*i+1];
    //printf("i:%d leva:%d desna:%d  seg:%d, br:%d\n",i,leva,desna, seg[i], br[i]);

}

int get(int i, int leva, int desna, int left, int right)
{
    //printf("%d ",i);
    if (leva==left && desna==right) return seg[i];
    int mid=(leva+desna)/2;
    if (right<=mid) return get(2*i,leva,mid,left,right);
    if (left>mid) return get(2*i+1,mid+1,desna,left,right);
    return get(2*i,leva,mid,left,mid)&get(2*i+1,mid+1,desna,mid+1,right);
}


int main()
{
    scanf("%d",&n);
    for (int i=1;i<=n;i++) scanf("%d",&a[i]);
    init(1,1,n);
    //printf("      %d      ",get(1,1,n,4,4));
    scanf("%d",&q);
    while (q--)
    {
        int t;
        scanf("%d",&t);
        if (t==1)
        {
            int x,y;
            scanf("%d%d",&x,&y);
            a[x]=y;
            update(1,1,n,x,y);
        }
        else
        {
            int x;
            scanf("%d",&x);
            if (seg[1]!=0)
            {
                printf("-1\n");
                continue;
            }
            if (a[x]==0)
            {
                printf("0\n");
                continue;
            }

            /*int leva=x+1;
            int desna=n;
            while (leva<desna && x<n)
            {
                int mid=(leva+desna)/2;
                if (get(1,1,n,x,mid)==0)
                {
                    desna=mid;
                }
                else leva=mid+1;
            }
            if (x<n) if (get(1,1,n,x,leva)) leva++;

            int nadesno=leva;

            leva=1;
            desna=x-1;
            while (leva<desna)
            {
                int mid=(leva+desna+1)/2;
                if (get(1,1,n,mid,x)==0) leva=mid;
                else desna=mid-1;
            }
            if (x>1) if (get(1,1,n,desna,x)) desna--;
            int nalevo=desna;

            //printf("nadesno=%d      nalevo=%d",nadesno,nalevo);

            int tren=-1;
            if (nadesno<=n) tren=nadesno-x;
            if (nalevo>0)
            {
                if (tren==-1) tren=x-nalevo;
                else tren=min(tren,x-nalevo);
            }
            printf("%d\n",tren);*/

            int provera=0;
            int d=min(x-1,n-x);
            int mini=2*n+10;
            for (int i=0;i<=n;i++)
            {
                for (int j=x;j>=x-i;j--)
                {
                    if (j<1 || j+i>n) continue;
                    if (!get(1,1,n,j,j+i))
                    {
                        int levo=x-j;
                        int desno=j+i-x;
                        if (mini>min(levo,desno)*2+max(levo,desno)) mini=min(levo,desno)*2+max(levo,desno);
                        provera=1;
                        break;
                    }
                }
            }
            if (!provera) printf("-1\n");
            else printf("%d\n",mini);

        }
    }
}